import os

YOSYS_BIN = "yosys"

def verilog_to_btor2(verilog_filepath: str, btor2_filepath: str):
    "Convert a Verilog file to BTOR2 format using Yosys."
    yosys_commands = [
        f"read_verilog {verilog_filepath}",
        "prep",
        "clean",
        "check",
        f"write_btor {btor2_filepath}",   
    ]
    if os.system(f"{YOSYS_BIN} -q -p '{'; '.join(yosys_commands)}'") != 0:
        raise RuntimeError("Yosys failed")


def _preprocess_line(line: str) -> str:
    "Removes comments and whitespaces in the line."
    comment_start = line.find(";")
    if comment_start >= 0:
        return line[:comment_start].strip()
    return line.strip()


def read_btor2_as_lines(btor2_filepath: str) -> list[str]:
    "Read BTOR2 file as lines with comments and whitespaces removed."
    with open(btor2_filepath, "r") as f:
        raw_lines = f.readlines()
    lines = []
    for raw_line in raw_lines:
        line = _preprocess_line(raw_line)
        if len(line) > 0:  # skip empty lines
            lines.append(line)
    return lines


def test():
    # verilog_to_btor2("../data/gcd_toy/gcd_fast.v", "../data/gcd_toy/gcd_fast.btor2")
    verilog_to_btor2("../data/gcd_toy/gcd_slow.v", "../data/gcd_toy/gcd_slow.btor2")


if __name__ == "__main__":
    test()