import sys
from preprocess import verilog_to_btor2, read_btor2_as_lines
from checker import Checker


def _load_file(src_filepath: str) -> str:
    "Loads a file. Returns the BTOR2 filepath."
    if src_filepath.endswith(".v"):
        btor2_filepath = src_filepath.replace(".v", ".btor2")
        verilog_to_btor2(src_filepath, btor2_filepath)
    else:
        if not src_filepath.endswith(".btor2"):
            raise ValueError(f"Unrecognized file extension for: {src_filepath}")
        btor2_filepath = src_filepath
    return btor2_filepath


def main(design_a_filepath: str, design_b_filepath: str, fast_slow_mode: bool):
    "Main function."

    btor2_a_filepath = _load_file(design_a_filepath)
    btor2_b_filepath = _load_file(design_b_filepath)

    a = read_btor2_as_lines(btor2_a_filepath)
    print(f"Successfully read design A from: {btor2_a_filepath}")

    b = read_btor2_as_lines(btor2_b_filepath)
    print(f"Successfully read design B from: {btor2_b_filepath}")

    checker = Checker(a, b, fast_slow_mode)
    print(f"Fast/slow mode?: {fast_slow_mode}")
    print()

    is_eq = checker.check()
    print()
    print("Equivalent." if is_eq else "Nonequivalent.")


if __name__ == "__main__":
    if len(sys.argv) == 4:
        _, design_a_filepath, design_b_filepath, fast_or_even = sys.argv
        fast_slow_mode = fast_or_even == "fast"
        main(design_a_filepath, design_b_filepath, fast_slow_mode)
    else:
        print("Usage: python3 main.py <design_a_filepath> <design_b_filepath> <'fast' or 'even'>")